﻿/////////////////////////////////////////////////
//　いんででフラクタル
//　http://sysys.blog.shinobi.jp/Entry/41/
/////////////////////////////////////////////////

if (app.scriptPreferences.version>=7) {
    app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
    app.doScript(main,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
} else {
    app.activeDocument.viewPreferences.properties={
        horizontalMeasurementUnits:MeasurementUnits.POINTS,
        verticalMeasurementUnits:MeasurementUnits.POINTS,
        lineMeasurementUnits:MeasurementUnits.POINTS,
        textSizeMeasurementUnits:MeasurementUnits.POINTS,
        typographicMeasurementUnits:MeasurementUnits.POINTS
    };
    main();
}
function main(){
    var pMax=50000;
    var delTempPath=true;

    var Sel0=app.activeDocument.selection[0]; 
    function getTM(x1,y1,x2,y2,x1d,y1d,x2d,y2d){
        var r1=Math.sqrt(Math.pow(x2-x1,2)+Math.pow(y2-y1,2));
        var r2=Math.sqrt(Math.pow(x2d-x1d,2)+Math.pow(y2d-y1d,2));
        var scale=r2/r1;
        var rotate=(Math.acos((x2-x1)/r1)*((y2-y1>0)?1:(-1)) -Math.acos((x2d-x1d)/r2)*((y2d-y1d>0)?1:(-1)))*180/Math.PI;
        var translate=[x1d-x1,y1d-y1];
        return app.transformationMatrices.add(scale,scale,0,rotate,translate[0],translate[1]);
    }
    var myPath=Sel0.paths[0];
    var en=myPath.entirePath;
    var perN=en.length-1;
    var tms=[];
    for (var i=0;i<en.length-1;i++){
        tms.push(getTM(en[0][0],en[0][1],en[perN][0],en[perN][1],en[i][0],en[i][1],en[i+1][0],en[i+1][1]));
    }
    for (var m=perN*perN;m<pMax;m*=perN){
        var ps=[];
        for (var i=0;i<tms.length;i++){
            var tempPath=Sel0.duplicate();
            tempPath.transform(CoordinateSpaces.SPREAD_COORDINATES,[en[0], AnchorPoint.topLeftAnchor],tms[i]);
            ps.push(tempPath);
        }
        for (var i=ps.length-1;i>0;i--){
            ps[i-1].paths[0].pathPoints.lastItem().join(ps[i].paths[0].pathPoints.firstItem(),JoinOptions.COMBINE);
        }
        if(delTempPath) Sel0.remove();
        Sel0=ps[0];
    }
}